﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using FDK;

namespace StrokeStyleT
{
	class CAct演奏コンボ : CActivity
	{
		public volatile int nCOMBO値;

		enum EEvent { 非表示, 数値更新, 同一数値, ミス }
		enum EMode { 非表示中, 表示中, 残像表示中 }
		const int nドラムコンボの文字間隔 = 2;
		const int n表示可能な最小コンボ数 = 11;

		public CAct演奏コンボ()
		{
			this.list子Activities.Add( this.mAct単位付き数値 = new CMAct単位付き数値・ジャンプ() );
		}

		public override void On活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してる )
				return;
			//-----------------
			#endregion

			this.e現在のモード = EMode.非表示中;
			this.nCOMBO値 = 0;
			this.n前のCOMBO値 = 0;
			this.nコンボが切れたときのCOMBO値 = 0;
			this.nコンボが切れた時刻 = CTimer.n未使用;

			base.On活性化();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.txCOMBOドラム = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay combo.png" ) );

			if( this.txCOMBOドラム != null )
			{
				this.txCOMBOドラム.n透明度 = 180;
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 0, 70 * 0, 45, 70 ) );	// 0
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 1, 70 * 0, 45, 70 ) );	// 1
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 2, 70 * 0, 45, 70 ) );	// 2
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 3, 70 * 0, 45, 70 ) );	// 3
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 4, 70 * 0, 45, 70 ) );	// 4
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 0, 70 * 1, 45, 70 ) );	// 5
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 1, 70 * 1, 45, 70 ) );	// 6
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 2, 70 * 1, 45, 70 ) );	// 7
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 3, 70 * 1, 45, 70 ) );	// 8
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 4, 70 * 1, 45, 70 ) );	// 9
				this.txCOMBOドラム.list描画範囲.Add( new Rectangle( 45 * 0, 70 * 2, 90, 32 ) );	// COMBO
			}

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.txCOMBOドラム );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return 0;
			//-----------------
			#endregion

			EEvent e今回の状態遷移イベント;

			#region [ 前回と今回の COMBO 値から、e今回の状態遷移イベントを決定する。]
			//-----------------
			int n前回の値 = this.n前のCOMBO値;
			int n今回の値 = this.nCOMBO値;

			if( n今回の値 < n表示可能な最小コンボ数 )		// 非表示　：表示可能な最小コンボ数に至ってない
				e今回の状態遷移イベント = EEvent.非表示;

			else if( n前回の値 == n今回の値 )				// 同一数値：前回とコンボ数が変わってない
				e今回の状態遷移イベント = EEvent.同一数値;

			else if( n前回の値 < n今回の値 )				// 数値更新：前回よりコンボ数が増えた（Combo継続）
				e今回の状態遷移イベント = EEvent.数値更新;

			else											// ミス　　：前回よりコンボ数が減った（Miss発生）
				e今回の状態遷移イベント = EEvent.ミス;
			//-----------------
			#endregion

			this.n前のCOMBO値 = this.nCOMBO値;

		Retry:	// モードが遷移した場合はここからリトライする。

			switch( this.e現在のモード )
			{
				case EMode.非表示中:
					#region [ イベントが「数値更新」の場合、「表示中」モードに遷移。]
					//-----------------
					if( e今回の状態遷移イベント == EEvent.数値更新 )
					{
						this.e現在のモード = EMode.表示中;
						goto Retry;
					}
					//-----------------
					#endregion
					#region [ それ以外はコンボ非表示。]
					//-----------------
					this.mAct単位付き数値.b表示 = false;
					//-----------------
					#endregion
					break;

				case EMode.表示中:
					#region [ イベントが「非表示」or「ミス」の場合「残像表示中」モードに遷移。]
					//-----------------
					if( ( e今回の状態遷移イベント == EEvent.非表示 ) || ( e今回の状態遷移イベント == EEvent.ミス ) )
					{
						this.e現在のモード = EMode.残像表示中;
						this.nコンボが切れたときのCOMBO値 = n前回の値;
						this.nコンボが切れた時刻 = Global.SoundTimer.n現在時刻ms;
						goto Retry;
					}
					//-----------------
					#endregion
					#region [ それ以外は今回のコンボ値を表示。]
					//-----------------
					this.mAct単位付き数値.n数値 = n今回の値;
					this.mAct単位付き数値.b表示 = true;
					//-----------------
					#endregion
					break;

				case EMode.残像表示中:
					#region [ イベントが「数値更新」の場合は「進行表示中」モードに遷移。]
					//-----------------
					if( e今回の状態遷移イベント == EEvent.数値更新 )
					{
						this.e現在のモード = EMode.表示中;
						goto Retry;
					}
					//-----------------
					#endregion
					#region [ 残像表示時間が切れた場合は「 非表示」モードに遷移。]
					//-----------------
					if( ( Global.SoundTimer.n現在時刻ms - this.nコンボが切れた時刻 ) > 1000 )	// 残像の表示時間は 1000ms 。
					{
						this.e現在のモード = EMode.非表示中;
						goto Retry;
					}
					//-----------------
					#endregion
					#region [ それ以外は残像表示期間であるので、コンボが切れたときの最後のコンボ値を表示。]
					//-----------------
					this.mAct単位付き数値.n数値 = this.nコンボが切れたときのCOMBO値;
					this.mAct単位付き数値.b表示 = true;
					//-----------------
					#endregion
					break;
			}

			// 子Activityの進行。

			this.mAct単位付き数値.On進行();
			
			return (int) E進行結果.継続;
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;

			if( this.txCOMBOドラム == null )
				return;
			//-----------------
			#endregion

			if( Global.User.Config.ComboPosition == Eコンボ表示位置.OFF )
				return;		// コンボは非表示。
			

			// 描画位置を決定。

			int n中央X = 0;
			switch( Global.User.Config.ComboPosition )
			{
				case Eコンボ表示位置.LEFT: n中央X = 300; break;
				case Eコンボ表示位置.CENTER: n中央X = 440; break;
				case Eコンボ表示位置.RIGHT: n中央X = 680; break;
			}
			int n下辺Y = 130;	// Y座標は固定位置


			// 描画。

			this.mAct単位付き数値.On描画( hDevice, this.txCOMBOドラム, n中央X, n下辺Y, CAct演奏コンボ.nドラムコンボの文字間隔 );
		}

		EMode e現在のモード;
		int n前のCOMBO値 = 0;
		long nコンボが切れた時刻;
		int nコンボが切れたときのCOMBO値;
		CMAct単位付き数値・ジャンプ mAct単位付き数値 = null;
		CTexture txCOMBOドラム;
	}
}
